'use client';

import { Card, CardContent } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import { useTranslations } from 'next-intl';

export default function CategoryGrid({ items, type, onItemClick, locale, goldKarat }) {
  const t = useTranslations();

  if (!items || items.length === 0) {
    return (
      <div className="text-center py-12 text-muted-foreground">
        No items found
      </div>
    );
  }

  return (
    <div className="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-6">
      {items.map((item) => {
        const name = locale === 'fa' ? item.nameFA : item.nameEN;
        const displayImage = item.image || item.images?.[0];

        return (
          <Card 
            key={item.id}
            className="cursor-pointer hover:shadow-lg transition-shadow overflow-hidden group"
            onClick={() => onItemClick(item)}
          >
            <div className="relative aspect-square bg-muted">
              {displayImage ? (
                <img 
                  src={displayImage}
                  alt={name}
                  className="w-full h-full object-cover group-hover:scale-105 transition-transform"
                />
              ) : (
                <div className="w-full h-full flex items-center justify-center text-muted-foreground">
                  No Image
                </div>
              )}
              
              {/* Overlay for category/subcategory */}
              {type !== 'product' && (
                <div className="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/70 to-transparent p-4">
                  <h3 className="text-white font-bold text-lg">{name}</h3>
                  {type === 'subcategory' && item.averageWeight && (
                    <p className="text-white/90 text-sm">
                      {t('products.averageWeight')}: {item.averageWeight} {t('common.gram')}
                    </p>
                  )}
                </div>
              )}
            </div>

            {/* Product details */}
            {type === 'product' && (
              <CardContent className="p-4">
                <div className="flex items-start justify-between">
                  <div className="flex-1">
                    <h3 className="font-semibold text-sm mb-1">{name}</h3>
                    {item.code && (
                      <p className="text-xs text-muted-foreground">{item.code}</p>
                    )}
                  </div>
                  <div className="text-right">
                    {goldKarat && item.weights && item.weights[goldKarat] && (
                      <Badge variant="secondary">
                        {item.weights[goldKarat]} {t('common.gram')}
                      </Badge>
                    )}
                  </div>
                </div>
              </CardContent>
            )}
          </Card>
        );
      })}
    </div>
  );
}