import { getRequestConfig } from 'next-intl/server';
import { notFound } from 'next/navigation';

export default getRequestConfig(async ({ requestLocale }) => {
  let locale = await requestLocale;
  
  // Validate locale
  const locales = ['fa', 'en'];
  if (!locale || !locales.includes(locale)) {
    locale = 'fa';
  }

  return {
    locale,
    messages: (await import(`./messages/${locale}.json`)).default
  };
});